# Genesis Testimonial Slider

* Contributors: wpstudio, frankschrijvers, seothemes
* Tags: testimonials, testimonial, testimonials plugin, widget, genesis, slider, Genesis Framework, genesiswp
* Requires at least: 3.6
* Tested up to: 5.2.2
* Stable tag: 1.5
* License: GPLv2 or later
* License URI: http://www.gnu.org/licenses/gpl-2.0.html

The Genesis Testimonials Slider is a simple-to-use plugin for adding Testimonials to your Genesis Theme, using a shortcode or a widget.

## Description

The Genesis Testimonials Slider allows users to add Testimonials to a widget area or to embed theme into a page or Post using the shortcode. The testimonials are customposts with author name, content and image. No more loss of data when switching themes.

**Please Note:** This plugin only works with the [Genesis Framework](http://www.studiopress.com/).

More information, an example and the manual can be found on [WPStudio](http://www.wpstud.io/plugins).


## Plugin features
- Plugin settings page
- Effect slide or fade
- Autoplay
- Show controls
- Pause on hover
- Set speed
- Set columns
- Set loop
- Set position image
- Add company name
- Add rating
- Genesis 2.0

## How to use
Add the Testimonial widget to a widget area or use the shortcode.
`[gts-slider]`

## Installation

1. You have a couple of options:
	* Go to Plugins -> Add New and search for "Genesis Countdown". Once found, click "Install".
	* Download the folder from Wordpress.org and unzip the folder. Then upload via Plugins -> Add New -> Upload.
2. Activate the plugin through the 'Plugins' menu in WordPress.

**Please Note:** This plugin is only for Genesis Framework users. Genesis is a premium product by [StudioPress](http://www.studiopress.com). If you do not have Genesis 2.0+ or Wordpress 3.6+, the plugin will not activate.

## Screenshots

*Testimonial slider default styling*
![Screenshot 1](https://www.wpstud.io/wp-content/uploads/2017/03/screenshot-1-1.jpg)

*Testimonial slider integrated in theme*
![Screenshot 2](https://www.wpstud.io/wp-content/uploads/2017/03/screenshot-2-1.jpg)


*Testimonial slider admin panel*
![CScreenshot 3](https://www.wpstud.io/wp-content/uploads/2017/03/screenshot-3-1.jpg)

## Changelog

**1.5**
* Update: fix for Genesis 3.0
* Removed genesis_pre function check on activation


**1.4**
- Tweak: removed Structured Data. Testimonials are used in many diffrent ways. The structured data is a limitation here.
- Bug fix: fixed Fatal error when shortcode and widget are used on same page.

**1.3**
- New: Add option to show testimonials in random order.

**1.2.6**

- Bug fix: fixed check wich causes a error 500 if switched to an none Genesis theme.
- Tweak: removed permalinks testimonials

**1.2.5**

 - Update: fix for Genesis 2.6
 - Tweak: small  code tweaks for WPCS
 - Update: add itemprop author
 - Update: made plugin ready for translation
 - Tweak: changed textdomain to slug

**1.2.4**

 - Set default params for scrolling speed

**1.2.3**

 - Set default params to avoid JS error's

**1.2.2**

 - Add missing files

**1.2.1**

 - Add missing files

**1.2**

 - Added rating stars
 - Added company field
 - New: Added select position image
 - New: Added schema microdata
 - Tweak: Updated code to WordPress coding standards
 - Tweak: Added responsive breakpoints

**1.1.3**

 - Fixed typo in link to WPStudio website

**1.1.2**

 - Fixed bug which shows slider always on top of the content using the shortcode

**1.1.1**

 - Add option for setting a loop
 - Fixed setting hover on pause

**1.0.1**

 - Fixed html widget. Add closing div.

**1.0**

 - Initial Release