<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

namespace StudioPress\Genesis\Admin\Install;

\add_action( 'after_switch_theme', __NAMESPACE__ . '\\insert_default_settings' );
/**
 * Inserts the default Genesis settings values into the options table, if they don't already exist.
 *
 * @since 3.0.3
 *
 * @return bool True of setting added, false otherwise.
 */
function insert_default_settings() {
	return add_option(
		GENESIS_SETTINGS_FIELD,
		[
			'update'                    => 1,
			'update_email_address'      => '',
			'blog_title'                => 'text',
			'style_selection'           => '',
			'site_layout'               => genesis_get_default_layout(),
			'superfish'                 => 0,
			'breadcrumb_home'           => 0,
			'breadcrumb_front_page'     => 0,
			'breadcrumb_posts_page'     => 0,
			'breadcrumb_single'         => 0,
			'breadcrumb_page'           => 0,
			'breadcrumb_archive'        => 0,
			'breadcrumb_404'            => 0,
			'breadcrumb_attachment'     => 0,
			'comments_pages'            => 0,
			'comments_posts'            => 1,
			'entry_meta_before_content' => '[post_date] ' . __( 'by', 'genesis' ) . ' [post_author_posts_link] [post_comments] [post_edit]',
			'entry_meta_after_content'  => '[post_categories] [post_tags]',
			'trackbacks_pages'          => 0,
			'trackbacks_posts'          => 1,
			'content_archive'           => 'full',
			'content_archive_limit'     => 0,
			'content_archive_thumbnail' => 0,
			'image_size'                => '',
			'image_alignment'           => 'alignleft',
			'posts_nav'                 => 'numeric',
			'header_scripts'            => '',
			'footer_scripts'            => '',
			'footer_text'               => sprintf( '[footer_copyright before="%s "] · [footer_childtheme_link before="" after=" %s"] [footer_genesis_link url="https://www.studiopress.com/" before=""] · [footer_wordpress_link] · [footer_loginout]', __( 'Copyright', 'genesis' ), __( 'on', 'genesis' ) ),
			'theme_version'             => PARENT_THEME_VERSION,
			'db_version'                => PARENT_DB_VERSION,
			'first_version'             => genesis_first_version(),
		],
		'',
		true
	);
}

\add_action( 'after_switch_theme', __NAMESPACE__ . '\\insert_default_seo_settings' );
/**
 * Inserts the default Genesis settings values into the options table, if they don't already exist.
 *
 * @since 3.0.3
 *
 * @return bool True of setting added, false otherwise.
 */
function insert_default_seo_settings() {
	return add_option(
		GENESIS_SEO_SETTINGS_FIELD,
		[
			'append_site_title'            => 0,
			'doctitle_sep'                 => '–',
			'doctitle_seplocation'         => 'right',
			'append_description_home'      => 1,
			'home_h1_on'                   => 'title',
			'home_doctitle'                => '',
			'home_description'             => '',
			'home_keywords'                => '',
			'home_noindex'                 => 0,
			'home_nofollow'                => 0,
			'home_noarchive'               => 0,
			'head_adjacent_posts_rel_link' => 0,
			'head_wlwmanifest_link'        => 0,
			'head_shortlink'               => 0,
			'noindex_cat_archive'          => 1,
			'noindex_tag_archive'          => 1,
			'noindex_author_archive'       => 1,
			'noindex_date_archive'         => 1,
			'noindex_search_archive'       => 1,
			'noarchive_cat_archive'        => 0,
			'noarchive_tag_archive'        => 0,
			'noarchive_author_archive'     => 0,
			'noarchive_date_archive'       => 0,
			'noarchive_search_archive'     => 0,
			'noarchive'                    => 0,
		],
		'',
		true
	);
}
