<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

/**
 * Manage Genesis Framework via cli - Backward compatibility.
 */
class Genesis_Cli_Command {
	/**
	 * Upgrade the database settings for Genesis, usually after an update.
	 *
	 * ## EXAMPLES
	 *
	 *  $ wp genesis upgrade-db
	 *  Success: Genesis database upgraded.
	 *
	 * @subcommand upgrade-db
	 * @alias upgrade_db
	 *
	 * @since 2.2.0
	 * @since 2.4.0 Command now invoked with `upgrade-db`, not `upgrade_db`, per WP-CLI standard.
	 *
	 * @param array $args       Positional arguments.
	 * @param array $assoc_args Stores all the arguments defined like --key=value or --flag or --no-flag.
	 */
	public function upgrade_db( $args, $assoc_args ) {
		WP_CLI::runcommand( 'genesis db upgrade' );
	}
}
