<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * These functions are intended to provide simple compatibility for those that don't have the mbstring
 * extension enabled. WordPress already provides a proper working definition for `mb_substr()`.
 *
 * @package Genesis\Compatibility
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

if ( ! function_exists( 'mb_strpos' ) ) {
	/**
	 * Add compatibility for undefined mb_strpos() by deferring to strpos().
	 *
	 * @since 2.0.0
	 *
	 * @param string $haystack The string being checked, for the last occurrence of `$needle`.
	 * @param string $needle   The string to find in `$haystack`.
	 * @param int    $offset   Optional. May be specified to begin searching an arbitrary number of characters
	 *                         into the string. Negative values will stop searching at an arbitrary
	 *                         point prior to the end of the string. Default is 0.
	 * @param string $encoding Optional. The encoding parameter is not used in `strpos()`. Default is an empty string.
	 * @return bool|int The numeric position of the first occurrence of `$needle` in the `$haystack` string.
	 *                  If needle is not found, it returns `false`.
	 */
	function mb_strpos( $haystack, $needle, $offset = 0, $encoding = '' ) {
		return strpos( $haystack, $needle, $offset );
	}
}

if ( ! function_exists( 'mb_strrpos' ) ) {
	/**
	 * Add compatibility for undefined mb_strrpos() by deferring to strrpos().
	 *
	 * @since 2.0.0
	 *
	 * @param string $haystack The string being checked, for the last occurrence of `$needle`.
	 * @param string $needle   The string to find in `$haystack`.
	 * @param int    $offset   Optional. May be specified to begin searching an arbitrary number of characters
	 *                         into the string. Negative values will stop searching at an arbitrary
	 *                         point prior to the end of the string. Default is 0.
	 * @param string $encoding Optional. The encoding parameter is not used in `strrpos()`. Default is an empty string.
	 * @return bool|int Numeric position of the last occurrence of `$needle` in the `$haystack` string.
	 *                  If needle is not found, it returns `false`.
	 */
	function mb_strrpos( $haystack, $needle, $offset = 0, $encoding = '' ) {
		return strrpos( $haystack, $needle, $offset );
	}
}

if ( ! function_exists( 'mb_strtolower' ) ) {
	/**
	 * Add compatibility for undefined mb_strtolower() by deferring to strtolower().
	 *
	 * @since 2.0.0
	 *
	 * @param string $string   The string being converted to lowercase.
	 * @param string $encoding Optional. The encoding parameter is the character encoding.
	 *                         If it is omitted, the internal character encoding value will be used.
	 * @return string `str` with all alphabetic characters converted to lowercase.
	 */
	function mb_strtolower( $string, $encoding = '' ) {
		return strtolower( $string );
	}
}

// Add compatibility for undefined wp_unique_id() by polyfilling; it was introduced in WP 5.0.3.
if ( ! function_exists( 'wp_unique_id' ) ) {
	/**
	 * Get unique ID.
	 *
	 * This is a PHP implementation of Underscore's uniqueId method. A static variable
	 * contains an integer that is incremented with each call. This number is returned
	 * with the optional prefix. As such the returned value is not universally unique,
	 * but it is unique across the life of the PHP process.
	 *
	 * @staticvar int $id_counter
	 *
	 * @param string $prefix Prefix for the returned ID.
	 * @return string Unique ID.
	 */
	function wp_unique_id( $prefix = '' ) { // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedFunctionFound -- adding backwards compatibility.
		static $id_counter = 0;
		return $prefix . ( ++$id_counter );
	}
}
