<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

/**
 * Handles system requirements checks.
 *
 * @since 2.7
 *
 * @return mixed Boolean true if the requirements are met, an array of messages if not.
 */
function genesis_check_requirements() {

	$requirements_met = true;

	$requirements = require get_template_directory() . '/config/requirements.php';

	if ( version_compare( $requirements['wordpress']['version'], $GLOBALS['wp_version'], '>' ) ) {
		$requirements_met = false;
		$messages[]       = $requirements['wordpress']['i18n']['requirements'];
	}

	if ( version_compare( $requirements['php']['version'], PHP_VERSION, '>' ) ) {
		$requirements_met = false;
		$messages[]       = $requirements['php']['i18n']['requirements'];
	}

	if ( $requirements_met ) {
		return true;
	}

	return $messages;
}

/**
 * Activates the default theme when requirements are not met.
 *
 * @since 2.7
 *
 * @param string   $stylesheet The previously-activated theme name.
 * @param WP_Theme $old_theme WP_Theme instance of the previously-activated theme.
 */
function genesis_activate_fallback_theme( $stylesheet, WP_Theme $old_theme ) {

	unset( $_GET['activated'] ); // phpcs:ignore WordPress.Security.NonceVerification.Recommended

	if ( $old_theme->exists() && strpos( $old_theme->get_stylesheet(), 'genesis' ) === false ) {
		$fallback_stylesheet = $old_theme->get_stylesheet();
	} else {
		$default_theme       = WP_Theme::get_core_default_theme();
		$fallback_stylesheet = $default_theme->get_stylesheet();
	}

	switch_theme( $fallback_stylesheet );
}
