<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package Genesis\Menus
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

add_filter( 'nav_menu_link_attributes', 'genesis_nav_menu_link_attributes' );
/**
 * Pass nav menu link attributes through attribute parser.
 *
 * Adds nav menu link attributes via the Genesis markup API.
 *
 * @since 2.2.0
 *
 * @param array $atts {
 *      The HTML attributes applied to the menu item's link element, empty strings are ignored.
 *
 *      @type string $title Title attribute.
 *      @type string $target Target attribute.
 *      @type string $rel The rel attribute.
 *      @type string $href The href attribute.
 * }
 * @return array Maybe modified menu attributes array.
 */
function genesis_nav_menu_link_attributes( $atts ) {

	return genesis_parse_attr( 'nav-link', $atts );

}

add_action( 'after_setup_theme', 'genesis_register_nav_menus' );
/**
 * Register the custom menu locations, if theme has support for them.
 *
 * Does the `genesis_register_nav_menus` action.
 *
 * @since 1.8.0
 *
 * @return void Return early if `genesis-menus` are not supported.
 */
function genesis_register_nav_menus() {

	if ( ! current_theme_supports( 'genesis-menus' ) ) {
		return;
	}

	$menus = get_theme_support( 'genesis-menus' );

	register_nav_menus( (array) $menus[0] );

	/**
	 * Fires after registering custom Genesis navigation menus.
	 *
	 * @since 1.8.0
	 */
	do_action( 'genesis_register_nav_menus' );

}

add_action( 'genesis_after_header', 'genesis_do_nav' );
/**
 * Echo the "Primary Navigation" menu.
 *
 * Applies the `genesis_do_nav` filter.
 *
 * @since 1.0.0
 */
function genesis_do_nav() {

	// Do nothing if menu not supported.
	if ( ! genesis_nav_menu_supported( 'primary' ) || ! has_nav_menu( 'primary' ) ) {
		return;
	}

	$class = 'menu genesis-nav-menu menu-primary';
	if ( genesis_superfish_enabled() ) {
		$class .= ' js-superfish';
	}

	genesis_nav_menu(
		[
			'theme_location' => 'primary',
			'menu_class'     => $class,
		]
	);

}

add_action( 'genesis_after_header', 'genesis_do_subnav' );
/**
 * Echo the "Secondary Navigation" menu.
 *
 * Applies the `genesis_do_subnav` filter.
 *
 * @since 1.0.0
 */
function genesis_do_subnav() {

	// Do nothing if menu not supported.
	if ( ! genesis_nav_menu_supported( 'secondary' ) ) {
		return;
	}

	$class = 'menu genesis-nav-menu menu-secondary';
	if ( genesis_superfish_enabled() ) {
		$class .= ' js-superfish';
	}

	genesis_nav_menu(
		[
			'theme_location' => 'secondary',
			'menu_class'     => $class,
		]
	);

}
